(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9596,        349]*)
(*NotebookOutlinePosition[     10936,        389]*)
(*  CellTagsIndexPosition[     10892,        385]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\ 
      Example\ 2.1  .1 . \ \[IndentingNewLine]Ritz\ method\ to\ determine\ \
eigenvalues\ of\ \n\t\tintegral\ equations\ with\ symmetric\ kernels\ *) \)\(\
\n\)\( (*\ k \((x, s)\) = \(s\ for\ x >= s\ and\  = x\ for\ x <= \ s\), \n\t
      on\ the\ interval\ \((0, 1)\)\ *) \)\(\n\)\( (*psi_n \((x)\) = 
        P_n \((2  x - 
              1)\)\ which\ are\ Legendre\ polynomials\ orthogonal\ in\ \((0, 
            1)\)\ *) \)\(\n\)\( (*\ Use\ two\ terms\ with\ P_  0, \ 
      P_  1\ and\ P_  2\ *) \)\(\n\)\(eq[m_, n_] := 
        Integrate\n[
          Integrate[
              s*\ LegendreP[m, 2\ \ s - 1]*
                LegendreP[n, 2\ \ x - 1], \n\t\t\t{s, \ 0, \ 
                x}] + \n\t\t\t\tIntegrate[
              x*LegendreP[m, 2\ \ s - 1]*
                LegendreP[n, 2\ x - 1], \n\t\t\t\t\t{s, \ x, \ 1}], \ \ {x, \ 
            0, \ 1}\ \ ];\)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = Table[eq[m, n], \ {m, 0, 1}, \ {n, 0, 1}]\)], "Input"],

Cell[BoxData[
    \({{1\/3, 1\/12}, {1\/12, 1\/30}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(psi[m_, n_] := 
      Integrate[
        LegendreP[m, 2\ x - 1]*\n\t\t\tLegendreP[n, 2\ x - 1], {x, 0, 1}]; \n
    b = Table[psi[m, n], \ {m, 0, 1}, \ {n, 0, 1}]\)], "Input"],

Cell[BoxData[
    \({{1, 0}, {0, 1\/3}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[a - x\ b]\)], "Input"],

Cell[BoxData[
    \(1\/240 - \(13\ x\)\/90 + x\^2\/3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[Det[a - x\ b] == 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0310745212389992753`}, {x \[Rule] 0.402258812094333961`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Eigenvalues\ are\ the\ values\ of\ 1/x\ *) \n
    1/0.0310745212389992753`\)\)], "Input"],

Cell[BoxData[
    \(32.180704967546716`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/0.402258812094333961`\)], "Input"],

Cell[BoxData[
    \(2.48596169911994202`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Exact\ eigen\ values\ are\ given\ by\ \((2  n - 1)\)^2\ Pi^2/4, 
      \n\tfor\ n = 1, \ 2, \  ... *) \n
    lambda[n_] := \ \((\ \((2  n - 1)\)^2*Pi^2/4)\) // N; \nlambda[1]\)\)], 
  "Input"],

Cell[BoxData[
    \(2.46740110027233949`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(lambda[2]\)], "Input"],

Cell[BoxData[
    \(22.2066099024510554`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\( (*\ 
      Ritz\ method\ to\ determine\ eigenvalues\ of\ \n\t\tintegral\ equations
        \ with\ symmetric\ kernels\ *) \n (*\ 
      k \((x, s)\) = \(s\ for\ x >= s\ and\  = x\ for\ x <= \ s\), \n\t
      on\ the\ interval\ \((0, 1)\)\ *) \n (*
      psi_n \((x)\) = 
        P_n \((2  x - 1)\)\ which\ are\ Legendre\ polynomials\ orthogonal\ in
          \ \((0, 1)\)\ *) \n (*\ Use\ three\ terms\ with\ P_  0, \ P_  1, \ 
      P_  2, \ P_  3\ *) \n\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p = Table[eq[m, n], \ {m, 0, 2}, \ {n, 0, 2}]\)], "Input"],

Cell[BoxData[
    \({{1\/3, 1\/12, \(-\(1\/60\)\)}, {1\/12, 1\/30, 0}, {\(-\(1\/60\)\), 0, 
        1\/210}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(q = Table[psi[m, n], \ {m, 0, 2}, \ {n, 0, 2}]\)], "Input"],

Cell[BoxData[
    \({{1, 0, 0}, {0, 1\/3, 0}, {0, 0, 1\/5}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[p - x\ q]\)], "Input"],

Cell[BoxData[
    \(1\/94500 - x\/700 + \(16\ x\^2\)\/525 - x\^3\/15\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[Det[p - x\ q] == 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.00916245895532766851`}, {
        x \[Rule] 0.0427510204576941088`}, {x \[Rule] 0.405229377729835338`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Eigen\ functions\ are\ the\ values\ of\ 1/x\ *) 1/
      0.00916245895532766851`\)\)], "Input"],

Cell[BoxData[
    \(109.14100732953711`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/0.0427510204576941088`\)], "Input"],

Cell[BoxData[
    \(23.3912545079383082`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/0.405229377729835338`\)], "Input"],

Cell[BoxData[
    \(2.46773816252457312`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(lambda[3]\)], "Input"],

Cell[BoxData[
    \(61.6850275068084918`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ 
      Ritz\ method\ to\ determine\ eigenvalues\ of\ \n\t\tintegral\ equations
        \ with\ symmetric\ kernels\ *) \n (*\ 
      k \((x, s)\) = \(s\ for\ x >= s\ and\  = x\ for\ x <= \ s\), \n\t
      on\ the\ interval\ \((0, 1)\)\ *) \n (*
      T_n \((x)\) T_n \((2  x - 1)\)\ which\ are\ Chebyshev\ polynomials\ of\ 
        first\ kind\ orthogonal\ in\ \((0, 1)\)\ *) \n (*\ 
      Use\ two\ terms\ with\ P_  0, \ P_  1\ and\ P_  2\ *) \n
    eq[m_, n_] := 
      Integrate\n[
        Integrate[s*\ ChebyshevT[m, 2\ \ s - 1]*ChebyshevT[n, 2\ \ x - 1], \n
            \t\t\t{s, \ 0, \ x}] + \n\t\t\t\t
          Integrate[x*ChebyshevT[m, 2\ \ s - 1]*ChebyshevT[n, 2\ x - 1], \n
            \t\t\t\t\t{s, \ x, \ 1}], \ \ {x, \ 0, \ 1}\ \ ]; 
    a1 = Table[eq[m, n], \ {m, 0, 1}, \ {n, 0, 1}]\)\)], "Input"],

Cell[BoxData[
    \({{1\/3, 1\/12}, {1\/12, 1\/30}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(psi[m_, n_] := 
      Integrate[
        ChebyshevT[m, 2\ x - 1]*\n\t\t\tChebyshevT[n, 2\ x - 1], {x, 0, 1}]; 
    \nb1 = Table[psi[m, n], \ {m, 0, 1}, \ {n, 0, 1}]\)], "Input"],

Cell[BoxData[
    \({{1, 0}, {0, 1\/3}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[a1 - x\ b1]\)], "Input"],

Cell[BoxData[
    \(1\/240 - \(13\ x\)\/90 + x\^2\/3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[Det[a1 - x\ b1] == 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.0310745212389992753`}, {x \[Rule] 0.402258812094333961`}}
      \)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      Same\ result\ as\ above\ using\ Legendre\ polynomials\n\twith\ two\ 
        terms\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ 
      Ritz\ method\ to\ determine\ eigenvalues\ of\ \n\t\tintegral\ equations
        \ with\ symmetric\ kernels\ *) \n (*\ 
      k \((x, s)\) = \(s\ for\ x >= s\ and\  = x\ for\ x <= \ s\), \n\t
      on\ the\ interval\ \((0, 1)\)\ *) \n (*
      T_n \((x)\) = 
        T_n \((2  x - 1)\)\ which\ are\ Chebyshev\ polynomials\ of\ first\ 
          kind\ orthogonal\ in\ \((0, 1)\)\ *) \n (*\ 
      Use\ three\ terms\ with\ T_  0, \ T_  1, \ T_  2, \ T_  3\ *) \n\n
    p1 = Table[eq[m, n], \ {m, 0, 2}, \ {n, 0, 2}]\)\)], "Input"],

Cell[BoxData[
    \({{1\/3, 1\/12, \(-\(2\/15\)\)}, {1\/12, 1\/30, \(-\(1\/36\)\)}, {
        \(-\(2\/15\)\), \(-\(1\/36\)\), 19\/315}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(q1 = Table[psi[m, n], \ {m, 0, 2}, \ {n, 0, 2}]\)], "Input"],

Cell[BoxData[
    \({{1, 0, \(-\(1\/3\)\)}, {0, 1\/3, 0}, {\(-\(1\/3\)\), 0, 7\/15}}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[p1 - x\ q1]\)], "Input"],

Cell[BoxData[
    \(4\/212625 - \(4\ x\)\/1575 + \(256\ x\^2\)\/4725 - 
      \(16\ x\^3\)\/135\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[Det[p1 - x\ q1] == 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.00916245895532766851`}, {
        x \[Rule] 0.0427510204576941088`}, {x \[Rule] 0.405229377729835338`}}
      \)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      Same\ result\ as\ above\ using\ Legendre\ polynomials\n\twith\ three\ 
        terms\ *) \)], "Input"]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False},
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002n88o?mooh<<H`Ui0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 910, 17, 267, "Input"],

Cell[CellGroupData[{
Cell[2652, 70, 78, 1, 27, "Input"],
Cell[2733, 73, 65, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2835, 79, 194, 4, 59, "Input"],
Cell[3032, 85, 53, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3122, 91, 46, 1, 27, "Input"],
Cell[3171, 94, 66, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3274, 100, 64, 1, 27, "Input"],
Cell[3341, 103, 112, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3490, 110, 116, 2, 43, "Input"],
Cell[3609, 114, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3699, 120, 56, 1, 27, "Input"],
Cell[3758, 123, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3849, 129, 219, 4, 75, "Input"],
Cell[4071, 135, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4162, 141, 42, 1, 27, "Input"],
Cell[4207, 144, 54, 1, 26, "Output"]
}, Open  ]],
Cell[4276, 148, 492, 9, 155, "Input"],

Cell[CellGroupData[{
Cell[4793, 161, 78, 1, 27, "Input"],
Cell[4874, 164, 122, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5033, 171, 79, 1, 27, "Input"],
Cell[5115, 174, 73, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5225, 180, 46, 1, 27, "Input"],
Cell[5274, 183, 82, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5393, 189, 64, 1, 27, "Input"],
Cell[5460, 192, 158, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5655, 200, 122, 2, 43, "Input"],
Cell[5780, 204, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5870, 210, 57, 1, 27, "Input"],
Cell[5930, 213, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6021, 219, 56, 1, 27, "Input"],
Cell[6080, 222, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6171, 228, 42, 1, 27, "Input"],
Cell[6216, 231, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6307, 237, 839, 15, 283, "Input"],
Cell[7149, 254, 65, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7251, 260, 197, 4, 59, "Input"],
Cell[7451, 266, 53, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7541, 272, 48, 1, 27, "Input"],
Cell[7592, 275, 66, 1, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7695, 281, 66, 1, 27, "Input"],
Cell[7764, 284, 112, 2, 26, "Output"]
}, Open  ]],
Cell[7891, 289, 132, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[8048, 296, 561, 10, 155, "Input"],
Cell[8612, 308, 149, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8798, 315, 80, 1, 27, "Input"],
Cell[8881, 318, 101, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9019, 325, 48, 1, 27, "Input"],
Cell[9070, 328, 109, 2, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9216, 335, 66, 1, 27, "Input"],
Cell[9285, 338, 158, 3, 26, "Output"]
}, Open  ]],
Cell[9458, 344, 134, 3, 43, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

